'use strict';

const _ = require('lodash');
const url = require('url');
const buildPath = require('../lib/build-path');

const BaseController = require('./base');
const CertificatesSearchModel = require('../model/certificates-search');

class CertificatesSearch extends BaseController {
    get pageName() {
        return 'certificates-search';
    }

    certificatesSearchPage() {
        var model = new CertificatesSearchModel(this._req);

        model
            .fetch()
            .bind(this)
            .then(this._toJSON)
            .then(this._extendData)
            .then(this._addSeoInfo)
            .then(this._render)
            .catch(this._renderError);
    }

    check() {
        var model = new CertificatesSearchModel(this._req);

        model
            .check(this._req.body)
            .bind(this)
            .then(this._toJSON)
            .then(this._sendJson)
            .catch(this._sendJsonError);
    }

    _addSeoInfo(data) {
        super._addSeoInfo(data);

        var cert = _.get(data, 'content.cert');

        if (!cert || cert.err) {
            return data;
        }

        _.assign(data.seo, {
            ogUrl: url.format({
                protocol: 'https',
                host: data.host,
                pathname: buildPath('certificates'),
                query: {
                    certId: cert.certId,
                    lastname: cert.lastname
                }
            }),
            ogImage: cert.image.orig
        });

        return data;
    }
}
module.exports = CertificatesSearch;
