'use strict';
const BaseController = require('./base');
const ExamClusterModel = require('../model/exam-cluster');
const { getBunkerNode, getPageLevels } = require('../lib/helper');
const _ = require('lodash');

class ExamCluster extends BaseController {
    get pageName() {
        return 'exam-cluster';
    }

    get clusterSlug() {
        return _.get(this._req, 'params.clusterSlug');
    }

    clusterPage() {
        var examCluster = new ExamClusterModel(this._req);

        examCluster
            .fetch()
            .bind(this)
            .then(super._toJSON)
            .then(this._addBunkerContent)
            .then(super._extendData)
            .then(this._addSeoInfo)
            .then(super._render)
            .catch(super._renderError);
    }

    _addBunkerContent(data) {
        const clusterNode = getBunkerNode(this._req, ['clusters', this.clusterSlug]);

        return _.assign({
            levels: getPageLevels(clusterNode)
        }, data);
    }
}
module.exports = ExamCluster;

