'use strict';

const _ = require('lodash');
const Promise = require('bluebird');
const BaseController = require('./base');
const getBunkerNode = require('../lib/helper').getBunkerNode;
const buildPath = require('../lib/build-path');

class Index extends BaseController {
    get pageName() {
        return 'index';
    }

    indexPage() {
        Promise
            .resolve({})
            .bind(this)
            .then(this._toJSON)
            .then(this._addBunkerContent)
            .then(this._extendData)
            .then(this._addSeoInfo)
            .then(this._render)
            .catch(this._renderError);
    }

    _addBunkerContent(data) {
        const mainpage = getBunkerNode(this._req, 'mainpage');
        const maintenance = getBunkerNode(this._req, ['settings', 'maintenance']);
        maintenance.isFrozen = _.some(maintenance.exams, 'isFrozen');

        data.levels = [
            {
                type: 'head',
                title: mainpage.title,
                text: mainpage.text,
                image: mainpage.image,
                maintenance: maintenance
            },
            {
                type: 'certifications',
                certifications: this._buildCertificationsUrls(mainpage.certifications)
            },
            {
                type: 'certificates-search',
                redirectPath: buildPath('certificates')
            }
        ];

        return data;
    }

    _buildCertificationsUrls(certifications) {
        return certifications.map(certification => {
            certification.link = certification.isCluster ?
                buildPath(certification.slug) :
                buildPath('exam', certification.slug);
            return certification;
        });
    }
}
module.exports = Index;
