'use strict';

const _ = require('lodash');
const Promise = require('bluebird');
const BaseController = require('./base');
const getBunkerNode = require('../lib/helper').getBunkerNode;

class Materials extends BaseController {
    get pageName() {
        return 'materials';
    }

    get materialCode() {
        return _.get(this._req, 'params.code');
    }

    get seoPath() {
        return `materials-${this.materialCode}`;
    }

    materialsPage() {
        Promise
            .resolve({})
            .bind(this)
            .then(this._toJSON)
            .then(this._addBunkerContent)
            .then(this._extendData)
            .then(this._addSeoInfo)
            .then(this._render)
            .catch(this._renderError);
    }

    _addBunkerContent(data) {
        const materials = getBunkerNode(this._req, ['materials', this.materialCode]);

        if (!_.isPlainObject(materials)) {
            throw new Error('Materials page not found');
        }

        return _.set(data, 'materials', materials);
    }
}
module.exports = Materials;
