'use strict';

const BaseController = require('./base');
const CertificatesModel = require('../model/certificates');

class MyCertificates extends BaseController {
    get pageName() {
        return 'my-certificates';
    }

    myCertificatesPage() {
        const model = new CertificatesModel(this._req);

        model
            .fetchMy()
            .bind(this)
            .then(this._toJSON)
            .then(this._extendData)
            .then(this._addSeoInfo)
            .then(this._render)
            .catch(this._renderError);
    }
}
module.exports = MyCertificates;
