'use strict';

const _ = require('lodash');
const BaseController = require('./base');
const CertificatesModel = require('../model/certificates');

class PublicCertificates extends BaseController {
    get pageName() {
        return 'public-certificates';
    }

    publicCertificatesPage() {
        var model = new CertificatesModel(this._req);

        model
            .fetchPublic()
            .bind(this)
            .then(this._toJSON)
            .then(this._extendData)
            .then(this._addSeoInfo)
            .then(this._render)
            .catch(this._renderError);
    }

    _addSeoInfo(data) {
        super._addSeoInfo(data);

        _.assign(data.seo, {
            ogUrl: data.currentUrl,
            ogImage: _.get(data, 'content.selectedCert.image.orig')
        });
        return data;
    }
}
module.exports = PublicCertificates;
