'use strict';

const Promise = require('bluebird');
const BaseController = require('./base');
const getBunkerNode = require('../lib/helper').getBunkerNode;

class Usage extends BaseController {
    get pageName() {
        return 'usage';
    }

    usagePage() {
        Promise
            .resolve({})
            .bind(this)
            .then(this._toJSON)
            .then(this._addBunkerContent)
            .then(this._extendData)
            .then(this._addSeoInfo)
            .then(this._render)
            .catch(this._renderError);
    }

    _addBunkerContent(data) {
        data.usage = getBunkerNode(this._req, 'usage');
        if (!data.usage) {
            throw new Error('Usage page not found');
        }
        return data;
    }
}
module.exports = Usage;
