'use strict';

const _ = require('lodash');
const config = require('cfg');
const path = require('path');

function buildPath(namespace) {
    return function () {
        var args = Array.prototype.slice.call(arguments);
        args = args.map(arg => {
            if (_.isString(arg)) {
                return arg;
            }

            if (_.isInteger(arg)) {
                return arg.toString();
            }

            throw new Error('Argument must be a string or a number');
        });

        return path.join.apply(path, [namespace].concat(args));
    };
}

module.exports = buildPath(config.router.namespace);
module.exports.ajax = buildPath(config.router.ajax);
