'use strict';

const route = {};
const express = require('express');
const appRouter = new express.Router();
const config = require('cfg');
const assert = require('assert');

function getControllerInstance(req, res, next) {
    var instanceController = new this.Controller(req, res, next);
    instanceController[this.nameMethod]();
}

['get', 'post'].forEach(method => {
    route[method] = function (app, url, controller, nameMethod, options) {
        assert(controller, 'Controller is not defined');
        options = options || {};
        appRouter[method](url, options.middleware || [], getControllerInstance.bind({
            Controller: controller,
            nameMethod
        }));
        var namespace = options.ajax ? config.router.ajax : config.router.namespace;
        app.use(namespace, appRouter);
        return this;
    };
});

module.exports = route;
