'use strict';

const logger = require('@yandex-int/yandex-logger');
const defaultPreset = require('@yandex-int/yandex-logger/middleware/preset-default');
const deployStream = require('@yandex-int/yandex-logger/streams/deploy');

module.exports = logger({
    name: 'expert-front',
    fields: {
        release: process.env.APP_VERSION,
        environment: process.env.NODE_ENV
    },
    middleware: [
        defaultPreset()
    ],
    streams: [
        {
            level: 'info',
            stream: deployStream()
        }
    ]
});
