'use strict';

const fs = require('fs');
const config = require('cfg');
const path = require('path');
const log = require('../logger');
const expressBunker = require('express-bunker');

module.exports = function () {
    const mockPath = path.join(__dirname, '../mock/bunker.json');
    const mockData = fs.existsSync(mockPath) && fs.readFileSync(mockPath);
    const parsedData = JSON.parse(mockData) || {};
    const bunkerMiddleware = expressBunker(config.bunker);

    return function (req, res, next) {
        bunkerMiddleware(req, res, err => {
            if (!err && req.bunker) {
                next();
                return;
            }

            if (err) {
                log.error(err, 'Bunker error');
            }

            req.bunker = parsedData;
            next();
        });
    };
};
