'use strict';

var Typer = require('bundle-typer');
var path = require('path');

var ExpertTyper = function () {
    Typer.apply(this, arguments);
};

ExpertTyper.prototype = Object.create(Typer.prototype);
ExpertTyper.prototype.get = function (bundleName) {
    // Что здесь происходит
    // Мы намеренно заворачиваем все шаблоны в index-бандл
    var result = Typer.prototype.get.call(this, 'index');

    // Но при этом в priv у нас должен вызываться
    // b-page_type_<имя бандла>
    result.name = path.basename(bundleName);

    return result;
};

module.exports = function (opts) {
    opts = opts || {};
    opts.cwd = opts.cwd || 'static';
    opts.lang = opts.lang || 'ru';
    opts.block = opts.block || 'page';

    return function (req, res, next) {
        var bundlePlatform = req.uatraits.isMobile ? 'touch-phone' : 'desktop';
        var bundle = res.bundle = new ExpertTyper(opts);

        res.bundle.render = function (bundleName, data) {
            bundle
                .lang(req.language)
                .type(bundlePlatform);

            data.bundlePlatform = bundlePlatform;
            // Callback mode gives +15k rps
            ExpertTyper.prototype.render.call(bundle, bundleName, data, function (err, html) {
                if (err) {
                    return res.emit('error', err);
                }
                res.send(html);
            });
        };

        next();
    };
};
