'use strict';

const _ = require('lodash');
const menuPrepare = require('../lib/menu-prepare');
const helper = require('../lib/helper');

module.exports = function () {
    return function (req, res, next) {
        const menuPrepareResult = menuPrepare(
            helper.getBunkerNode(req, ['main-menu']),
            helper.removeLastSlash(req.originalUrl),
            false,
            req.query.menu === 'open'
        );
        const rootBreadcrumbs = _.get(helper.getBunkerNode(req, ['settings']), 'rootBreadcrumbs', []);

        req.base.mainMenu = menuPrepareResult.item;
        req.base.mainMenu.rootBreadcrumbs = rootBreadcrumbs;
        req.base.mainMenu.additionalBreadcrumbs = [];
        req.base.breadcrumbsChain = menuPrepareResult.currentIndexChain;

        next();
    };
};
