'use strict';

const config = require('cfg');
const log = require('../logger');
const expressHttpUatraits = require('@yandex-int/express-http-uatraits');

module.exports = function () {
    const uatraitsMiddleware = expressHttpUatraits(config.uatraits);

    return function (req, res, next) {
        uatraitsMiddleware(req, res, () => {
            if (req.uatraits && !req.uatraits.error) {
                next();
                return;
            }

            log.error(req.uatraits.error, 'Uatraits error');

            req.uatraits = config.uatraitsDefaultValues;
            next();
        });
    };
};
