'use strict';

const config = require('cfg');

const BaseModel = require('./base');
const _ = require('lodash');
const buildPath = require('../lib/build-path');
const { getMaterials } = require('../lib/helper');

class AttemptResultModel extends BaseModel {
    fetch() {
        var options = {
            method: 'POST',
            body: {},
            url: this._path('/attempt', this._req.params.attemptId, 'result')
        };
        return this._request(options)
            .bind(this)
            .then(this._prepareMaterials);
    }

    _parseData() {
        _.assign(this._data, {
            isCertification: _.get(this._data, 'type.code') === 'cert',
            isAchievement: _.get(this._data, 'type.code') === 'achievement',
            attemptId: this._req.params.attemptId
        });

        if (this._data.certId) {
            this._data.downloadUrl = buildPath('certificate', 'pdf', this._data.hashedUserId, this._data.certId);
        }

        const { total } = this._data;
        const isWaitingForRevision = total.isRevisionRequested &&
            total.lastVerdict === 'failed' &&
            (total.lastSource === 'proctoring' || total.lastSource === 'toloka');

        if (total.passed && (total.lastVerdict === 'pending' || isWaitingForRevision)) {
            this._data.pendingImage = config.pendingImage;
            this._data.isWaitingForRevision = isWaitingForRevision;
        }

        this._data = this._resizeCertImage(this._data);
        this._data.linkToMain = buildPath('/');

        return this;
    }

    _prepareMaterials() {
        const examSlug = _.get(this._req, 'params.examSlug');
        const sections = _.get(this._data, 'sections');
        const lastSource = _.get(this._data, 'total.lastSource');

        this._data.materials = getMaterials(this._req, { examSlug, sections, lastSource });

        return this;
    }
}

module.exports = AttemptResultModel;
