'use strict';

const Promise = require('bluebird');
const BaseModel = require('./base');
const buildPath = require('../lib/build-path');
const escapeName = require('../lib/helper').escapeName;

const _ = require('lodash');

class CertificatesSearch extends BaseModel {
    fetch() {
        var certId = this._req.query.certId;
        var lastname = this._req.query.lastname;

        var request = certId && lastname ?
            this._tryCheck(certId, lastname) :
            Promise.resolve({});

        return request
            .bind(this)
            .then(this._addValidateUrl);
    }

    check(body) {
        var options = {
            method: 'POST',
            body: {
                certId: parseInt(body.certId, 10),
                lastname: body.lastname
            },
            url: '/certificate/find'
        };
        return this._request(options)
            .bind(this)
            .then(this._addCertInfo);
    }

    _addValidateUrl() {
        this._data = _.assign(this._data, {
            validateUrl: buildPath.ajax('certificates', 'check')
        });

        return this;
    }

    _addCertInfo() {
        var cert = escapeName(this._data);
        var isExpired = new Date(cert.dueDate) < new Date();

        cert.active = (!cert.active || isExpired) ? 'inactive' : 'active';

        this._data = this._resizeCertImage(cert);

        return this;
    }

    _tryCheck(certId, lastname) {
        return this
            .check({ certId, lastname })
            .then(function () {
                this._data = { cert: this._data };
                return this;
            })
            .catch(function (error) {
                var internalCode = _.get(error, 'response.body.internalCode');
                var err = { internalCode };
                var cert = { err, certId, lastname };
                this._data = { cert };
                return this;
            });
    }
}

module.exports = CertificatesSearch;
