'use strict';

const _ = require('lodash');
const BaseModel = require('./base');
const buildPath = require('../lib/build-path');
const buildQueryStr = require('../lib/helper').buildQueryStr;
const escapeName = require('../lib/helper').escapeName;

class ExamAccess extends BaseModel {
    get examSlug() {
        return _.get(this._req, 'params.examSlug');
    }

    get retlink() {
        return _.get(this._req, 'query.retlink');
    }

    fetch() {
        const options = {
            url: this._path('/attempt', this.examSlug, 'check')
        };

        return this._request(options)
            .bind(this)
            .catch(err => {
                const internalCode = _.get(err, 'response.body.internalCode');

                if (internalCode === '403_UIS') {
                    this._data = { isSpammer: true };

                    return this;
                }

                throw err;
            });
    }

    _getAttempt() {
        if (this._data.state === 'in_progress') {
            return {
                attemptId: this._data.attemptId,
                openId: this._data.openId
            };
        }
    }

    _parseData() {
        const { attemptId, openId } = this._getAttempt() || {};

        if (attemptId) {
            const query = buildQueryStr({ openId, retlink: this.retlink });
            this._data.attemptUrl = `${buildPath('exam', this.examSlug, attemptId)}${query}`;
        }

        this._data = escapeName(this._data);

        return this;
    }
}

module.exports = ExamAccess;
