'use strict';

const _ = require('lodash');
const buildPath = require('../lib/build-path');

const BaseModel = require('./base');

class ExamCluster extends BaseModel {
    get clusterSlug() {
        return _.get(this._req, 'params.clusterSlug');
    }

    fetch() {
        var options = {
            url: this._path('/exam/cluster', this.clusterSlug)
        };
        return this._request(options);
    }

    _parseData() {
        this._data.exams = this._data.map(this._addExamLink);
        return this;
    }

    _addExamLink(exam) {
        exam.link = buildPath('exam', exam.slug);
        return exam;
    }
}

module.exports = ExamCluster;
