'use strict';

const _ = require('lodash');
const config = require('cfg');

const BaseModel = require('./base');
const buildPath = require('../lib/build-path');
const buildQueryStr = require('../lib/helper').buildQueryStr;

class Exam extends BaseModel {
    get examSlug() {
        return _.get(this._req, 'params.examSlug');
    }

    get retlink() {
        return _.get(this._req, 'query.retlink');
    }

    get serviceSlug() {
        return _.get(this._data, 'service.code');
    }

    fetch() {
        var options = {
            url: this._path('/exam', this.examSlug)
        };
        return this._request(options);
    }

    _parseData() {
        const attemptPath = this._data.isProctoring ? 'go' : 'start';
        const isAchievement = _.get(this._data, 'type.code') === 'achievement';

        const queryStr = buildQueryStr({ retlink: this.retlink });

        this._data.attemptUrl = buildPath('exam', this.examSlug, attemptPath) + queryStr;
        this._data.startUrl = buildPath('exam', this.examSlug, 'start') + queryStr;
        this._data.image = isAchievement ? '' : _.get(config.badges, [this.serviceSlug, 'orig']);
        this._data.imageCert = isAchievement ? '' : _.get(config.exampleCert, [this.serviceSlug, 'orig']);
        return this;
    }
}

module.exports = Exam;
