'use strict';

const Promise = require('bluebird');

const BaseModel = require('./base');

class Identification extends BaseModel {
    fetch() {
        const { face, document } = this._req.body;

        if (!face || !document) {
            return Promise.reject();
        }

        const options = {
            method: 'POST',
            url: this._path('/identification', this._req.params.examSlug, '/photo'),
            body: { face, document },
            json: false
        };

        return this._request(options);
    }
}

module.exports = Identification;
