module.exports = function (bh) {
    'use strict';

    bh.match('achievement', function (ctx, json) {
        var achievement = json.achievement;

        ctx.content([
            {
                elem: 'preview',
                content: {
                    block: 'image',
                    url: achievement.previewImagePath
                }
            },
            {
                elem: 'title',
                content: bh.lib.i18n('common', 'achievement.share.' + achievement.exam.slug)
            },
            json.share && !achievement.isHiddenExam && {
                block: 'cert-share',
                options: {
                    url: achievement.achievementUrl
                },
                mods: { offset: 'top', align: 'center' }
            }
        ]);
    });
};
