/* global BEM */
BEM.DOM.decl('animation-events', {}, {
    onAnimation: function (elem, type, callback) {
        this
            ._getAnimationEvents(type)
            .forEach(function (event) {
                elem.on(event, callback);
            });
    },

    offAnimation: function (elem, type, callback) {
        this
            ._getAnimationEvents(type)
            .forEach(function (event) {
                elem.off(event, callback);
            });
    },

    _getAnimationEvents: function (type) {
        var eventName = 'Animation' + type;

        return ['webkit', 'moz', 'MS', 'o', ''].map(function (prefix) {
            if (!prefix) {
                return eventName.toLowerCase();
            }

            return prefix + eventName;
        });
    }
});
