module.exports = function (bh) {
    'use strict';
    bh.match('attempt-progress', function (ctx, json) {
        var countAnswered = json.countAnswered;
        var questionCount = json.questionCount;

        if (!bh.lib.util.is.integer(countAnswered) || !bh.lib.util.is.integer(questionCount)) {
            return '';
        }

        var percent = Math.round((countAnswered / questionCount) * 100);

        ctx
            .js(true)
            .content([
                {
                    elem: 'text',
                    percent: percent
                },
                {
                    elem: 'wrapper',
                    percent: percent
                }
            ]);
    });

    bh.match('attempt-progress__wrapper', function (ctx, json) {
        ctx.content({
            elem: 'bar',
            percent: json.percent
        });
    });

    bh.match('attempt-progress__bar', function (ctx, json) {
        ctx.attr('style', 'width:' + json.percent + '%;');
    });
};
