/* global BEM */
BEM.DOM.decl('attempt-progress', {
    onSetMod: {
        js: function () {
            'use strict';

            this._percent = this.elem('percent');
            this._bar = this.elem('bar');

            this.bindToWin('progress-change', this._onProgressChange.bind(this));
        }
    },

    _onProgressChange: function (e, data) {
        'use strict';
        if (!data.trial) {
            return;
        }

        var percent = Math.round((data.trial.countAnswered / data.trial.questionCount) * 100);
        this._percent.text(percent);
        this._bar.attr('style', 'width:' + percent + '%;');
    }
});
