module.exports = function (bh) {
    'use strict';

    bh.match('attempt-result_type_cert', function (ctx, json) {
        var result = json.data.content;
        var isPassed = Boolean(result.total.passed);
        var isWaitingForRevision = json.isWaitingForRevision;
        var isCritMetrics = result.total.lastSource === 'crit-metrics';

        ctx.content([
            {
                block: 'cert-preview',
                cert: result,
                passportProfile: json.data.passportProfile,
                isWaitingForRevision: isWaitingForRevision
            },
            result.certId && {
                block: 'cert-share',
                downloadUrl: result.downloadUrl,
                options: {
                    url: result.certUrl,
                    image: result.image.orig
                }
            },
            !isCritMetrics && {
                elem: 'table',
                result: result
            },
            !result.certId && isPassed && result.isProctoring && [
                {
                    elem: 'proctoring',
                    result: result,
                    isWaitingForRevision: isWaitingForRevision
                },
                {
                    elem: 'read-rules',
                    status: result.total.lastVerdict,
                    rulesUrl: json.rulesUrl,
                    isWaitingForRevision: isWaitingForRevision
                }
            ],
            !result.certId && !isWaitingForRevision && {
                elem: 'next-attempt',
                availabilityDate: result.availabilityDate
            },
            {
                elem: 'link-to-main',
                linkToMain: result.linkToMain
            }
        ]);
    });

    bh.match('attempt-result_type_achievement', function (ctx, json) {
        var result = json.data.content;
        var isCritMetrics = result.total.lastSource === 'crit-metrics';
        var date = bh.lib.util.date.dateStringToDate(result.finished);
        var additionalInfo = result.additionalInfo;
        var isHiddenExam = result.isHiddenExam;

        ctx.content([
            {
                block: 'image',
                url: result.image.orig
            },
            result.achievementUrl && !isHiddenExam && {
                block: 'cert-share',
                options: {
                    url: result.achievementUrl,
                    image: result.image.orig
                }
            },
            additionalInfo && additionalInfo.infoEnabled && {
                elem: 'additional-info',
                additionalInfo: additionalInfo
            },
            !isCritMetrics && [
                {
                    elem: 'attempt-date',
                    content: bh.lib.i18n('common', 'result.header') + date
                },
                !isHiddenExam && {
                    elem: 'table',
                    result: result
                }
            ],
            {
                elem: 'link-to-main',
                linkToMain: result.linkToMain
            }
        ]);
    });

    bh.match('attempt-result__table', function (ctx, json) {
        var result = json.result;

        ctx.content({
            block: 'table',
            mods: {
                type: 'result',
                passed: result.total.passed ? 'yes' : 'no'
            },
            head: [
                bh.lib.i18n('common', 'result.section'),
                bh.lib.i18n('common', 'result.level_of_knowledge')
            ],
            body: result.sections.map(function (section, i) {
                return {
                    mods: {
                        passed: section.passed ? 'yes' : 'no'
                    },
                    content: [
                        i + 1 + ". " + section.title,
                        bh.lib.util.math.getPercents(section.correctCount, section.totalCount)
                    ]
                };
            })
        });
    });

    bh.match('attempt-result__next-attempt', function (ctx, json) {
        if (!json.availabilityDate) {
            return '';
        }

        var date = new Date(json.availabilityDate);
        var text = bh.lib.i18n('common', 'result.next_attempt') + ' ' + bh.lib.util.date.humanizeDate(date.getTime());

        ctx.content(text);
    });

    bh.match('attempt-result__link-to-main', function (ctx, json) {
        ctx.content({
            block: 'link',
            mods: { theme: 'expert' },
            text: bh.lib.i18n('common', 'result.back_to_main'),
            url: json.linkToMain
        });
    });

    bh.match('attempt-result__proctoring', function (ctx, json) {
        var result = json.result;
        var isWaitingForRevision = json.isWaitingForRevision;
        var status = isWaitingForRevision ? 'pending' : result.total.lastVerdict;

        ctx.content({
            block: 'table',
            mods: {
                type: 'proctoring',
                status: status
            },
            body: [
                {
                    content: [
                        {
                            elem: 'text',
                            content: bh.lib.i18n('common', 'result.proctoring.title')
                        },
                        {
                            elem: 'text',
                            content: bh.lib.i18n('common', 'result.proctoring.status.' + status)
                        }
                    ]
                }]

        });
    });

    bh.match('attempt-result__additional-info', function (ctx, json) {
        var additionalInfo = json.additionalInfo;

        ctx.content([
            [
                {
                    elem: 'additional-text',
                    mix: { block: 'html-content' },
                    content: additionalInfo.text
                },
                {
                    block: 'button2',
                    mods: {
                        type: 'link',
                        theme: 'action',
                        size: 'm'
                    },
                    url: additionalInfo.link,
                    text: additionalInfo.buttonText,
                    target: '_self'
                }
            ]
        ]);
    });
};
