module.exports = function (bh) {
    'use strict';
    bh.match('attempt-time', function (ctx, json) {
        var started = json.started;
        var timeLimit = json.timeLimit;
        var serverTime = json.serverTime;

        if (!started || !timeLimit || !serverTime) {
            return '';
        }

        var timeLeft = bh.lib.util.date.getTimeLeft(started, timeLimit);

        ctx
            .js({
                started: started,
                timeLimit: timeLimit,
                serverTime: serverTime,
                pingUrl: json.pingUrl
            })
            .content([
                {
                    elem: 'text',
                    message: bh.lib.i18n('common', 'attempt.time')
                },
                {
                    elem: 'time',
                    time: bh.lib.util.date.msToTime(timeLeft)
                }
            ]);
    });
};
