/* global BEM, BH, $ */
BEM.DOM.decl('attempt-time', {
    onSetMod: {
        js: function () {
            'use strict';

            this._INTERVAL = 1000;
            this.syncServerTime(this.params.serverTime);
            this._started = this.params.started;
            this._timeLimit = this.params.timeLimit;
            this._timeLeft = 0;
            this._timeElem = this.elem('time');
            this._timeout = setTimeout(this._tickTimer.bind(this), this._INTERVAL);
            this._popup = this.findBlockInside('popup2');
            this._timeHandler = this._syncTimeWithServer.bind(this);

            document.addEventListener('visibilitychange', this._timeHandler);

            if (this._popup) {
                this._initPopup();
            }
        }
    },

    _tickTimer: function () {
        'use strict';

        if (this._timeLeft) {
            this._prevTimeLeft = this._timeLeft;
        }

        this._timeLeft = BH.lib.util.date.getTimeLeft(this._started, this._timeLimit) - this._delta;

        if (this._prevTimeLeft < this._timeLeft) {
            this._syncTimeWithServer();
            return;
        }

        this._timeout = setTimeout(this._tickTimer.bind(this), this._INTERVAL);

        if (this._timeLeft <= 0) {
            this._timeLeft = 0;
            clearTimeout(this._timeout);
        }

        this._timeElem.text(BH.lib.util.date.msToTime(this._timeLeft));
    },

    _initPopup: function () {
        this._popup.setAnchor(this);

        this.bindTo('pointerclick', function () {
            this._popup.toggleMod('visible', 'yes');
        }.bind(this));
    },

    _syncTimeWithServer: function () {
        if (document.visibilityState !== 'visible') {
            return;
        }

        $.get(this.params.pingUrl + '?' + Math.floor(Math.random() * 100000))
            .done(this._onPingResponse.bind(this));
    },

    _onPingResponse: function (data, status, xhr) {
        var serverTime = new Date(xhr.getResponseHeader('Date'));
        if (!isNaN(serverTime.getTime())) {
            this.syncServerTime(serverTime);
            this._tickTimer();
        }
    },

    /**
     * Синхронизирует время таймера с временем сервера
     * @param serverTime
     */
    syncServerTime: function (serverTime) {
        this._delta = new Date(serverTime) - new Date();
    },

    /**
     * Останавливает счет времени
     */
    stopServerTime: function () {
        document.removeEventListener('visibilitychange', this._timeHandler);

        clearTimeout(this._timeout);
    }
});
