module.exports = function (blocks) {
    'use strict';

    function getText(result) {
        var total = result.total;
        var lastSource = total.lastSource;

        if (!result.isProctoring) {
            var serviceCode = result.isAchievement ? '.' + result.service.code : '';

            return total.passed ? '' : 'result.fail.subtitle' + serviceCode;
        }

        if (lastSource === 'crit-metrics') {
            return result.isNullified ?
                'result.fail.crit-metrics.nullified' :
                'result.fail.crit-metrics';
        }

        if (!total.passed) {
            return 'result.fail.subtitle.pro-knowledge';
        }

        if (total.lastVerdict === 'pending') {
            return 'result.pending.subtitle';
        }

        if (lastSource === 'metrics') {
            return 'result.fail.no-revision';
        }

        if (lastSource === 'appeal') {
            return 'result.fail.appeal';
        }

        if (lastSource === 'toloka-revision') {
            return 'result.fail.toloka-revision';
        }

        if (total.isRevisionRequested) {
            return 'result.request-revision';
        }

        return 'result.fail.subtitle.proctoring';
    }

    function getTitle(result, isWaitingForRevision) {
        if (result.certId) {
            return 'result.success.title';
        }

        if (result.total.passed && (result.total.lastVerdict === 'pending' || isWaitingForRevision)) {
            return 'result.pending.title';
        }

        return 'result.fail.title';
    }

    blocks.declare('b-page_type_attempt-result', function (data) {
        var result = data.content;
        var isWaitingForRevision = result.isWaitingForRevision;

        var title = getTitle(result, isWaitingForRevision);
        var subtitle = result.certId && 'result.success.' + result.service.code;
        var text = !result.certId && getText(result);
        var hasMaterials = result.materials.sections.length > 0;

        return [
            {
                block: 'layout',
                mods: { width: 's' },
                content: [
                    {
                        block: 'page-title',
                        title: title,
                        subtitle: subtitle,
                        text: text,
                        form: result.isProctoring && {
                            attemptId: result.attemptId,
                            formId: data.formId
                        }
                    },
                    {
                        block: 'attempt-result',
                        mods: {
                            type: result.type.code
                        },
                        data: data,
                        rulesUrl: data.content.rulesUrl,
                        isWaitingForRevision: isWaitingForRevision
                    }
                ],
                footer: hasMaterials && {
                    block: 'materials',
                    mods: { align: 'center' },
                    materials: result.materials
                }
            }
        ];
    });
};
