module.exports = function (blocks) {
    'use strict';
    blocks.declare('b-page_type_attempt', function (data) {
        var content = data.content;

        return [
            {
                block: 'subhead',
                content: [
                    {
                        block: 'attempt-progress',
                        countAnswered: content.trial.countAnswered,
                        questionCount: content.trial.questionCount
                    },
                    {
                        block: 'attempt-time',
                        started: content.trial.started,
                        timeLimit: content.trial.timeLimit,
                        serverTime: data.serverTime,
                        pingUrl: content.pingUrl
                    }
                ]
            },
            {
                block: 'layout',
                content: {
                    block: 'question',
                    question: content,
                    proctoringIframeUrl: data.proctoringIframeUrl,
                    proctoringIframeHost: data.proctoringIframeHost,
                    openId: data.openId,
                    attemptId: content.attemptId,
                    userProctoringToken: data.userProctoringToken
                }
            },
            content.exam.isProctoring && {
                block: 'proctoring-footer',
                mods: { notifications: 'yes' },
                formId: data.formId,
                attemptId: content.attemptId,
                data: content.proctoringFooter,
                openId: data.openId
            }
        ];
    });
};
