module.exports = function (blocks) {
    'use strict';
    blocks.declare('b-page_type_exam', function (data) {
        var exam = data.content.exam;
        var examAccess = data.content.examAccess;

        return [
            {
                block: 'layout',
                content: [
                    {
                        block: 'maintenance',
                        maintenance: data.content.maintenance
                    },
                    {
                        block: 'content',
                        mods: { columns: 'two' },
                        rows: [
                            [
                                {
                                    elem: 'title',
                                    content: exam.title
                                },
                                ''
                            ],
                            [
                                {
                                    mix: { block: 'html-content' },
                                    content: [
                                        exam.image && {
                                            block: 'image',
                                            mods: { type: 'exam' },
                                            url: exam.image,
                                            alt: exam.title
                                        },
                                        exam.description
                                    ]
                                }
                            ],
                            [
                                {
                                    block: 'exam-info',
                                    content: [
                                        {
                                            block: 'exam-metrics',
                                            content: [
                                                {
                                                    elem: 'item',
                                                    metric: exam.questionsCount,
                                                    key: 'exam.metric.count'
                                                },
                                                {
                                                    elem: 'item',
                                                    metric: exam.sectionsCount,
                                                    key: 'exam.metric.sections'
                                                }
                                            ]
                                        },
                                        {
                                            block: 'example-cert',
                                            content: [
                                                exam.imageCert && {
                                                    block: 'image',
                                                    mods: { type: 'exam-cert-img' },
                                                    url: exam.imageCert,
                                                    alt: exam.title
                                                }
                                            ]
                                        }
                                    ]
                                },
                                {
                                    block: 'exam-start',
                                    exam: exam,
                                    examAccess: examAccess,
                                    isAuthorized: Boolean(data.userInfo.uid),
                                    isBrowserSupportProctoring: data.isBrowserSupportProctoring,
                                    passportProfile: data.passportProfile,
                                    login: data.userInfo.login,
                                    terms: data.content.terms
                                }
                            ],
                            [
                                {
                                    block: 'b-page',
                                    elem: 'howto-anchor',
                                    attrs: { id: 'howto' }
                                }
                            ],
                            [
                                {
                                    elem: 'subtitle',
                                    key: 'exam.rules'
                                },
                                ''
                            ],
                            [
                                {
                                    mix: { block: 'html-content' },
                                    content: exam.rules
                                },
                                ''
                            ]
                        ]
                    }
                ]
            }
        ];
    });
};
