module.exports = function (blocks) {
    'use strict';
    blocks.declare('b-page_type_identification', function (data) {
        var content = data.content;
        var identification = content.identification;
        var queryOpenId = data.openId ? ('?openId=' + data.openId) : '';
        var startUrl = content.exam.startUrl + queryOpenId;

        return [
            {
                block: 'identification-header',
                text: content.identification.title
            },
            {
                block: 'layout',
                content: {
                    block: 'content',
                    content: [
                        {
                            block: 'identification',
                            data: identification,
                            startUrl: startUrl,
                            identificationUrl: content.identificationUrl,
                            proctoringIframeUrl: data.proctoringIframeUrl,
                            proctoringIframeHost: data.proctoringIframeHost,
                            userProctoringToken: data.userProctoringToken,
                            screencastUrl: content.screencastUrl.url,
                            openId: data.openId
                        }
                    ]
                }
            },
            {
                block: 'proctoring-footer',
                mods: { notifications: 'no' },
                formId: data.formId,
                data: content.proctoringFooter,
                openId: data.openId
            }
        ];
    });
};
