module.exports = function (blocks) {
    'use strict';
    blocks.declare('b-page_type_public-certificates', data => {
        var certificates = data.content.certificates;

        return {
            block: 'layout',
            mods: { width: 's' },
            content: [
                {
                    block: 'page-title',
                    title: data.content.firstname + ' ' + data.content.lastname,
                    text: 'public-certificates.subtitle'
                },
                certificates.cert.active.map(cert => ({
                    block: 'cert',
                    data: {
                        collapsible: true,
                        cert: cert
                    }
                })),
                certificates.cert.inactive.length > 0 && {
                    block: 'cert-archive',
                    certificates: certificates.cert.inactive
                },
                certificates.achievement.length > 0 && {
                    block: 'achievements',
                    achievements: certificates.achievement
                }
            ]
        };
    });
};
