module.exports = function (blocks) {
    'use strict';
    var getSidebarPusher = function (data, page) {
        var openMenu = data.mainMenu.openMenu;

        return {
            block: 'sidebar-pusher',
            mods: {
                pushed: openMenu && 'yes'
            },
            content: [
                {
                    elem: 'content',
                    content: [
                        blocks.exec(`b-page_type_${page}`, data),
                        blocks.exec('levels', data),
                        blocks.exec('debug', data),
                        blocks.exec('footer', data)
                    ]
                }
            ]
        };
    };

    blocks.declare('b-page', (data, page) => {
        var bundleName = 'index';
        var bundlePlatform = data.bundlePlatform;
        var isMobile = bundlePlatform === 'touch-phone';
        var meta = data.content.meta;

        return [
            {
                block: 'i-global',
                params: {
                    id: 'expert-front',
                    lang: data.language,
                    tld: data.tld,
                    contentRegion: data.contentRegion,
                    secretkey: data.secretkey,
                    retpath: data.retpath,
                    host: `https://${data.host}`,
                    'social-retpath': `${data.homeUrl}social-broker__closer.html`,
                    login: data.userInfo.login || data.blackbox.displayName,
                    uid: data.userInfo.uid,
                    yandexuid: data.userInfo.yandexuid,
                    nonce: data.nonce,
                    socialList: data.socialList,
                    'passport-host': data.passportHost,
                    isMobile: data.uatraits.isMobile,
                    browser: data.uatraits.BrowserName,
                    regions: data.regions,
                    subscribeFormPath: data.subscribeFormPath,
                    logUrl: data.logUrl
                }
            },
            {
                block: 'raven-init',
                raven: data.raven
            },
            {
                block: 'b-page',
                mods: { type: page },
                head: [
                    { elem: 'css', url: `${data.staticHost}/${bundlePlatform}.bundles/${bundleName}/_${bundleName}.css`, ie: false },
                    !isMobile && { elem: 'css', url: `${data.staticHost}/${bundlePlatform}.bundles/${bundleName}/_${bundleName}`, ie: true },
                    {
                        elem: 'link',
                        rel: 'shortcut icon',
                        url: data.faviconUrl
                    },
                    blocks.exec('seo', data),
                    {
                        elem: 'meta',
                        attrs: {
                            name: 'viewport',
                            content: 'width=device-width' + (isMobile ? ',minimum-scale=1,maximum-scale=1,' +
                            'initial-scale=1,user-scalable=no' : '')
                        }
                    },
                    isMobile && [
                        {
                            elem: 'meta',
                            attrs: {
                                name: 'format-detection',
                                content: 'telephone=no'
                            }
                        },
                        {
                            elem: 'meta',
                            attrs: {
                                name: 'mobile-web-app-capable',
                                content: 'yes'
                            }
                        }
                    ],
                    meta && meta.noindex && { elem: 'meta', attrs: { name: 'robots', content: 'noindex' }}
                ],
                xUaCompatible: 'IE=edge',
                content: [
                    {
                        elem: 'wrapper',
                        data: data,
                        content: [
                            {
                                block: 'sidebar',
                                phoneData: data.settings.footer,
                                cta: data.settings.cta
                            },
                            {
                                block: 'sidebar-dimmer'
                            },
                            getSidebarPusher(data, page)
                        ]
                    },
                    {
                        elem: 'js',
                        url: 'https://yastatic.net/ravenjs/3.23.3/raven.min.js'
                    },
                    !isMobile && {
                        elem: 'cc',
                        condition: 'IE 8',
                        content: { elem: 'js', url: 'https://yastatic.net/es5-shims/0.0.2/es5-shims.min.js' }
                    },
                    { elem: 'js', url: 'https://yastatic.net/jquery/1.12.0/jquery.min.js' },
                    {
                        elem: 'js',
                        url: `${data.staticHost}/${bundlePlatform}.bundles/${bundleName}/_${bundleName}.${data.language}.js`
                    },
                    blocks.exec('scripts-loader', data),
                    blocks.exec('metrika', data)
                ]
            }
        ];
    });
};
