module.exports = function (bh) {
    'use strict';

    bh.match('badges', function (ctx, json) {
        var data = json.data;
        var certData = json.certData;
        var certTitle = json.certTitle;
        var badgesSizes = data.badgesSizes;

        ctx
            .js({
                badges: data.badges,
                badgeCode: data.badgeCode,
                badgesSizes: badgesSizes,
                certData: certData,
                certTitle: certTitle
            })
            .content([
                {
                    elem: 'close',
                    content: {
                        block: 'icon',
                        mods: { type: 'close', source: 'badge' }
                    }
                },
                {
                    elem: 'title',
                    content: bh.lib.i18n('common', 'my-certificates.title')
                },
                {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    content: bh.lib.i18n('common', 'my-certificates.description_popup', { url: json.publicPageUrl })
                },
                {
                    elem: 'check',
                    badges: data.badges,
                    badgesSizes: badgesSizes
                },
                {
                    elem: 'code',
                    content: [
                        {
                            block: 'input',
                            mods: {
                                size: 's',
                                type: 'textarea',
                                clear: 'no'
                            },
                            content: [
                                {
                                    elem: 'control',
                                    attrs: { readonly: 'yes' }
                                }
                            ]
                        }
                    ]
                }
            ]);
    });

    bh.match('badges__check', function (ctx, json) {
        var badges = json.badges;
        var badgesSizes = json.badgesSizes;
        var badgesTypes = Object.keys(badgesSizes);

        ctx.content([
            {
                block: 'radiobox',
                mods: {
                    theme: 'normal',
                    size: 'm',
                    type: 'badges'
                },
                name: 'badges',
                value: 'm',
                content: badgesTypes.map(function (type) {
                    return {
                        elem: 'radio',
                        mods: { type: type },
                        controlAttrs: { value: type },
                        src: badges[type],
                        badgeSize: badgesSizes[type],
                        type: type
                    };
                })
            }
        ]);
    });
};
