/* global BEM, $ */
BEM.DOM.decl('badges', {
    onSetMod: {
        js: {
            inited: function () {
                'use strict';

                this._badgeCodePattern = /{(.*?)}/g;
                this._defaultBadgeType = 'm';

                this._code = this.findElem('code');
                this._textarea = this.findBlockInside(this._code, 'input');
                this._radiobox = this.findBlockInside({ block: 'radiobox', modName: 'type', modVal: 'badges' });
                this._modal = this.findBlockOutside('modal');
                this._close = this.findElem('close');

                this.bindTo(this._radiobox.domElem, 'pointerclick', this._onRadioboxChange.bind(this));
                this.bindTo(this._close, 'pointerclick', this._closeModal.bind(this));

                this._updateTextarea(this._defaultBadgeType);
            }
        }
    },

    _onRadioboxChange: function (e) {
        'use strict';

        e.stopPropagation();
        var type = e.target.value;

        if (type) {
            this._updateTextarea(type);
        }
    },

    _closeModal: function () {
        'use strict';

        this._modal.delMod('visible');
    },

    _compileBadgeCode: function (params) {
        'use strict';
        return this.params.badgeCode.replace(this._badgeCodePattern, function (param) {
            var paramName = param.slice(1, param.length - 1);

            return params[paramName] || '';
        });
    },

    _updateTextarea: function (type) {
        'use strict';

        var options = $.extend({
            src: this.params.badges[type],
            certId: this.params.certData.certId,
            lastname: this.params.certData.lastname,
            title: this.params.certTitle
        }, this.params.badgesSizes[type]);

        this._textarea.val(this._compileBadgeCode(options));
    }
});
