module.exports = function (bh) {
    var SERVICES_VIEW = {
        ru: [
            ['events', 'science', 'edu'],
            ['company', 'blog', 'vacancies', 'tech', 'adv']
        ],
        ua: [
            ['company', 'vacancies', 'blog', 'adv']
        ],
        by: [
            ['company', 'blog', 'vacancies', 'adv']
        ],
        kz: [
            ['company', 'blog', 'vacancies', 'adv']
        ],
        com: [
            ['company', 'vacancies', 'tech', 'adv', 'events']
        ],
        'com.tr': [
            ['company', 'blog', 'vacancies', 'tech', 'adv']
        ]
    };

    var SERVICES_URL = {
        adv: {
            ru: '//yandex.ru/adv',
            ua: '//yandex.ua/adv',
            by: '//yandex.by/adv',
            kz: '//yandex.kz/adv',
            com: '//yandex.com/adv',
            'com.tr': '//yandex.com.tr/adv'
        },
        company: {
            ru: '//yandex.ru/company/',
            com: '//yandex.com/company/',
            ua: '//yandex.ua/company/',
            kz: '//yandex.ru/company/',
            by: '//yandex.ru/company/',
            'com.tr': '//yandex.com.tr/company/'
        },
        vacancies: {
            ru: '//yandex.ru/jobs/',
            com: '//yandex.com/jobs',
            ua: '//yandex.ua/jobs/',
            kz: '//yandex.ru/jobs/',
            by: '//yandex.ru/jobs/',
            'com.tr': '//yandex.com.tr/jobs'
        },
        tech: {
            ru: '//tech.yandex.ru',
            com: '//tech.yandex.com',
            ua: '//tech.yandex.ru',
            kz: '//tech.yandex.ru',
            by: '//tech.yandex.ru',
            'com.tr': '//tech.yandex.com.tr'
        },
        events: {
            ru: '//events.yandex.ru',
            com: '//events.yandex.com/events/',
            ua: '//events.yandex.ru',
            kz: '//events.yandex.ru',
            by: '//events.yandex.ru',
            'com.tr': '//events.yandex.com/events/'
        },
        science: {
            ru: '//research.yandex.ru',
            com: '//events.yandex.com/research/',
            ua: '//research.yandex.ru',
            kz: '//research.yandex.ru',
            by: '//research.yandex.ru',
            'com.tr': '//events.yandex.com/research/'
        },
        edu: {
            ru: '//academy.yandex.ru',
            ua: '//academy.yandex.ru',
            kz: '//academy.yandex.ru',
            by: '//academy.yandex.ru'
        },
        blog: {
            ru: '//yandex.ru/blog/company',
            ua: '//yandex.ua/blog/company',
            kz: '//yandex.ru/blog/company',
            by: '//yandex.ru/blog/company',
            com: '//yandex.com/blog/company',
            'com.tr': '//yandex.com.tr/blog/company'
        }
    };

    bh.lib.getHeaderMenu = function (region) {
        var view = SERVICES_VIEW[region];

        return view.map(function (level) {
            return level.map(function (serviceId) {
                var isCurrent = serviceId === 'adv';

                return {
                    name: bh.lib.i18n('header', 'service.' + serviceId),
                    current: isCurrent,
                    url: SERVICES_URL[serviceId][region]
                };
            });
        });
    };
};
