module.exports = function (bh) {
    'use strict';
    bh.match('cert-archive', function (ctx, json) {
        ctx.content({
            block: 'table',
            mods: { type: 'archive' },
            head: [
                bh.lib.i18n('common', 'table.service'),
                bh.lib.i18n('common', 'table.number'),
                bh.lib.i18n('common', 'table.duedate')
            ],
            body: json.certificates.map(function (cert) {
                return {
                    content: [
                        cert.service.title,
                        {
                            block: 'link',
                            mods: { theme: 'expert' },
                            text: cert.certId,
                            url: cert.certUrl
                        },
                        bh.lib.util.date.dateStringToDate(cert.dueDate)
                    ]
                };
            })
        });
    });
};
