module.exports = function (bh) {
    'use strict';
    bh.match('cert-info_collapsible_yes', function (ctx) {
        ctx
            .js(true)
            .content([
                {
                    elem: 'toggle'
                },
                {
                    elem: 'collapsible',
                    content: ctx.content()
                }
            ], true);
    });

    bh.match('cert-info', function (ctx, json) {
        var cert = json.cert;
        var annotation = bh.lib.i18n('common', 'cert.annotation.' + cert.service.code, {
            firstname: cert.firstname,
            lastname: cert.lastname
        });

        ctx.content([
            {
                elem: 'table',
                cert: cert
            },
            (cert.active === 'active') && annotation && {
                elem: 'annotation',
                content: annotation
            }
        ]);
    });

    bh.match('cert-info__table', function (ctx, json) {
        var cert = json.cert;

        ctx
            .tag('table')
            .content([
                {
                    tag: 'tr',
                    content: [
                        {
                            tag: 'td',
                            content: bh.lib.i18n('common', 'cert.info.id')
                        },
                        {
                            elem: 'td-content',
                            tag: 'td',
                            content: '№' + cert.certId
                        }
                    ]
                },
                {
                    tag: 'tr',
                    content: [
                        {
                            tag: 'td',
                            content: bh.lib.i18n('common', 'cert.info.owner')
                        },
                        {
                            elem: 'td-content',
                            tag: 'td',
                            content: cert.firstname + ' ' + cert.lastname
                        }
                    ]
                },
                {
                    tag: 'tr',
                    content: [
                        {
                            tag: 'td',
                            content: bh.lib.i18n('common', 'cert.info.service')
                        },
                        {
                            elem: 'td-content',
                            tag: 'td',
                            content: cert.service.title
                        }
                    ]
                },
                {
                    tag: 'tr',
                    content: [
                        {
                            tag: 'td',
                            content: bh.lib.i18n('common', 'cert.info.status')
                        },
                        {
                            elem: 'td-content',
                            tag: 'td',
                            mods: { active: cert.active === 'active' ? 'yes' : 'no' },
                            content: bh.lib.i18n('common', cert.active === 'active' ? 'cert.status.active' : 'cert.status.expired')
                        }
                    ]
                },
                (cert.active === 'active') && {
                    tag: 'tr',
                    content: [
                        {
                            tag: 'td',
                            content: bh.lib.i18n('common', 'cert.info.duedate')
                        },
                        {
                            elem: 'td-content',
                            tag: 'td',
                            content: bh.lib.util.date.dateStringToDate(cert.dueDate)
                        }
                    ]
                }
            ]);
    });

    bh.match('cert-info__toggle', function (ctx) {
        ctx.content([
            {
                elem: 'toggle-content',
                content: bh.lib.i18n('common', 'cert.info.collapse')
            }
        ]);
    });
};
