module.exports = function (bh) {
    'use strict';

    bh.match('cert-preview', function (ctx, json) {
        var cert = json.cert;
        var isPending = cert.total && cert.total.passed &&
            (cert.total.lastVerdict === 'pending' || json.isWaitingForRevision);

        if (isPending) {
            ctx.content({
                elem: 'pending-wrapper',
                content: {
                    elem: 'image',
                    pendingImage: cert.pendingImage,
                    alt: bh.lib.i18n('cert', 'pending-alt')
                }
            });

            return;
        }

        if (!cert.certId) {
            return '';
        }

        var layout = json.isOldDesign ? 'old' : 'initials';
        var alt = cert.firstname + ' ' + cert.lastname + ' - ' + bh.lib.i18n('cert', 'status');

        ctx
            .mods({
                layout: layout,
                type: cert.service.code
            })
            .content({
                elem: 'wrapper',
                content: {
                    elem: 'image',
                    cert: cert,
                    alt: alt
                }
            });

        return [
            ctx.json(),
            json.passportProfile && {
                elem: 'text',
                content: [
                    bh.lib.i18n('common', 'result.cert_data'),
                    {
                        block: 'link',
                        mods: { theme: 'expert' },
                        url: json.passportProfile,
                        text: bh.lib.i18n('common', 'result.ya_passport')
                    }
                ]
            }
        ];
    });
};
