module.exports = function (bh) {
    'use strict';
    bh.match('cert-share', function (ctx, json) {
        var data = json.data;
        var certData = json.certData;
        var publicPageUrl = json.publicPageUrl;
        var hideShare = json.hideShare;

        var serviceCode = data && certData && certData.exam && data.examSlugToServiceCode[certData.exam.slug];
        var serviceName = bh.lib.i18n('cert', serviceCode);
        var certTitle = bh.lib.i18n('cert', 'achievement', { service: serviceName });

        ctx
            .js({
                data: data,
                certData: certData,
                certTitle: certTitle,
                publicPageUrl: publicPageUrl
            })
            .content([
                {
                    elem: 'share',
                    mods: hideShare && { page: 'my-certificates' },
                    hideShare: hideShare,
                    options: json.options
                },
                {
                    elem: 'controls',
                    content: [
                        data && data.badges && {
                            elem: 'get-code'
                        },
                        json.downloadUrl && {
                            elem: 'download',
                            url: json.downloadUrl
                        }
                    ]
                },
                data && {
                    elem: 'popup',
                    certPopupSrc: data.certPopupSrc,
                    certPopupSize: data.certPopupSize,
                    certTitle: certTitle
                }
            ]);
    });
};
