/* global BEM, BH */
BEM.DOM.decl('cert-share', {
    onSetMod: {
        js: {
            inited: function () {
                'use strict';

                var body = this.findBlockOutside('b-page');
                var getCode = this.findElem('get-code');
                var download = this.findElem('download');
                var certPopupElem = this.findElem('popup');

                this._getCodeButton = this.findBlockInside(getCode, 'button2');
                this._downloadButton = this.findBlockInside(download, 'button2');
                this._modal = body.findBlockInside('modal');
                this._shareButton = this.findElem('share');
                this._popup = this.findBlockInside({ block: 'popup2', modName: 'source', modVal: 'cert-share' });
                this._certPopup = this.findBlockInside(certPopupElem, 'popup2');

                if (this._popup) {
                    this._popup.setAnchor(this._shareButton);
                    this._popup.on('beforeClose', this._disableButton.bind(this));
                }

                this.bindTo(this._shareButton, 'click', this._showPopup.bind(this));

                if (this._getCodeButton) {
                    this.bindTo(this._getCodeButton.domElem, 'click', this._getCode.bind(this));
                }

                if (this.params.data && this.params.data.isYaLetterCert && this._certPopup && this._downloadButton) {
                    var downloadButtonElem = this._downloadButton.domElem;

                    this.bindTo(downloadButtonElem, 'mousemove', this._onDownloadButtonMouseHover.bind(this));
                    this.bindTo(downloadButtonElem, 'mouseout', this._hideCertPopup.bind(this));
                }

                if (this._modal) {
                    this._modal.on('beforeClose', this._destructBadges.bind(this));
                }
            }
        }
    },

    _getCode: function () {
        'use strict';

        this._modal.setContent(BH.apply({
            block: 'badges',
            data: this.params.data,
            certData: this.params.certData,
            publicPageUrl: this.params.publicPageUrl,
            certTitle: this.params.certTitle
        }));

        this._modal.setMod('visible', 'yes');
    },

    _destructBadges: function () {
        'use strict';

        var badges = this._modal.findBlockInside('badges');

        if (badges) {
            badges.destruct();
        }
    },

    _showPopup: function () {
        'use strict';

        if (this._popup) {
            this._popup.setMod('visible', 'yes');
        }

        this._enableButton();
    },

    _enableButton: function () {
        'use strict';

        this.setMod(this._shareButton, 'active', 'yes');
    },

    _disableButton: function () {
        'use strict';

        this.delMod(this._shareButton, 'active');
    },

    _onDownloadButtonMouseHover: function (e) {
        'use strict';

        this._certPopup.setPosition(e.pageX, e.pageY);

        if (!this._certPopup.hasMod('visible', 'yes')) {
            this._showCertPopup();
        }
    },

    _showCertPopup: function () {
        'use strict';

        this._certPopup.setMod('visible', 'yes');
    },

    _hideCertPopup: function () {
        'use strict';

        this._certPopup.delMod('visible');
    }
});
