module.exports = function (bh) {
    'use strict';
    bh.match('cert-start', function (ctx, json) {
        if (json.cert.check.state !== 'enabled' || !json.cert.attemptUrl) {
            return '';
        }

        ctx.content([
            {
                elem: 'description',
                content: bh.lib.i18n('common', 'exam.start.description', {
                    param: bh.lib.util.date.dateStringToDate(json.cert.dueDate)
                })
            },
            {
                elem: 'button',
                attemptUrl: json.cert.attemptUrl
            }
        ]);
    });
};
