module.exports = function (bh) {
    'use strict';
    bh.match('cert', function (ctx, json) {
        var DESIGN_CHANGE_DATE = new Date(2016, 1, 15);
        var SERVICES_WITH_OLD_DESIGN = ['direct', 'metrika'];
        var data = json.data;
        var certData = data.cert;
        var publicPageUrl = data.publicPageUrl;
        var hideShare = data.hideShare;

        if (!data.cert || data.cert.err) {
            return '';
        }

        var isObtainedBeforeDesignChange = new Date(data.cert.confirmedDate) <= DESIGN_CHANGE_DATE;
        var isOldDesignServiceCode = SERVICES_WITH_OLD_DESIGN.indexOf(data.cert.service.code) > -1;
        var isOldDesign = isObtainedBeforeDesignChange && isOldDesignServiceCode;
        var showCertPreview = data.cert.image.w600 || isOldDesign;

        ctx.content([
            showCertPreview && {
                block: 'cert-preview',
                isOldDesign: isOldDesign,
                cert: data.cert
            },
            data.start && certData.isExamAllowed && {
                block: 'cert-start',
                cert: data.cert
            },
            {
                block: 'cert-info',
                mods: { collapsible: data.collapsible && 'yes' },
                cert: data.cert
            },
            data.share && showCertPreview && {
                block: 'cert-share',
                downloadUrl: data.cert.downloadUrl,
                data: data.cert,
                hideShare: hideShare,
                publicPageUrl: publicPageUrl,
                certData: certData,
                mods: { offset: 'top' },
                options: {
                    url: data.cert.certUrl,
                    image: data.cert.image.orig
                }
            }
        ]);
    });
};
