module.exports = function (bh) {
    'use strict';
    bh.match('certificates-search', function (ctx, json) {
        ctx
            .js({
                validateUrl: json.validateUrl
            })
            .content([
                {
                    elem: 'title',
                    mix: { block: 'content', elem: 'title' },
                    content: bh.lib.i18n('common', 'certificates-search.title')
                },
                {
                    block: 'search-form',
                    cert: json.cert
                },
                {
                    elem: 'cert',
                    content: {
                        elem: 'cert-data',
                        cert: json.cert
                    }
                },
                {
                    elem: 'error',
                    cert: json.cert
                }
            ]);
    });

    bh.match('certificates-search__title', function (ctx) {
        ctx.tag('h1');
    });

    bh.match('certificates-search__cert-data', function (ctx, json) {
        if (!json.cert || json.cert.err) {
            return '';
        }

        ctx.content({
            block: 'cert',
            data: {
                cert: json.cert
            }
        });
    });

    bh.match('certificates-search__error', function (ctx, json) {
        if (!json.cert || !json.cert.err) {
            return;
        }

        var errorCode = json.cert.err.internalCode || 'certificates-search.default';
        var reason = bh.lib.i18n('errors', errorCode);

        ctx
            .mod('visible', 'yes')
            .content(bh.lib.i18n('errors', 'certificates-search', { reason: reason }));
    });
};
