/* global BEM, BH, $ */
BEM.DOM.decl('certificates-search', {
    onSetMod: {
        js: function () {
            this._form = this.findBlockInside('search-form');
            this._cert = this.findElem('cert');
            this._error = this.findElem('error');

            this._form.on('submit', this._sendData.bind(this));
        }
    },

    _sendData: function (e, formData) {
        this._hideError();
        this._form.disableControls();
        this._destructCert();

        $.ajax({
            type: 'POST',
            url: this.params.validateUrl,
            headers: {
                'x-csrf-token': formData.sk
            },
            contentType: 'application/json',
            data: JSON.stringify(formData.data)
        })
            .done(this._onChecked.bind(this))
            .fail(this._onError.bind(this))
            .always(this._onResponse.bind(this));
    },

    _onChecked: function (data) {
        'use strict';
        var cert = BH.apply({
            block: 'certificates-search',
            elem: 'cert-data',
            cert: data
        });

        BEM.DOM.update(this._cert, cert);
        this._form.enableControls();
    },

    _onError: function (err) {
        'use strict';
        var errorText = BEM.blocks['i-bem'].createErrorMessage(err, 'certificates-search', 'certificates-search.default');
        this._form.enableControls();
        this._error.html(errorText);
        this.setMod(this._error, 'visible', 'yes');
    },

    _onResponse: function () {
        if (BH.lib.global.isMobile) {
            BEM.blocks['scroll-to'].scrollTo(this._cert);
        }
    },

    _hideError: function () {
        'use strict';
        this.delMod(this._error, 'visible');
    },

    _destructCert: function () {
        'use strict';
        BEM.DOM.destruct(this.findElem('cert-data'));
    }
});
