module.exports = function (bh) {
    'use strict';
    bh.match('certification', function (ctx, json) {
        var certification = json.certification;

        if (!certification) {
            return '';
        }

        ctx
            .tParam('certification', certification)
            .content([
                {
                    elem: 'head',
                    content: certification.type
                },
                { elem: 'wrapper' }
            ]);
    });

    bh.match('certification__wrapper', function (ctx) {
        ctx.content([
            { elem: 'image' },
            { elem: 'info' }
        ]);
    });

    bh.match('certification__image', function (ctx) {
        var certification = ctx.tParam('certification');

        ctx.content({
            tag: 'a',
            attrs: { href: certification.link },
            content: {
                elem: 'img',
                tag: 'img',
                attrs: {
                    src: certification.image,
                    title: certification.title,
                    alt: certification.type
                }
            }
        });
    });

    bh.match('certification__info', function (ctx) {
        var certification = ctx.tParam('certification');

        ctx.content([
            {
                elem: 'info-head',
                content: certification.type
            },
            { elem: 'title' },
            {
                elem: 'text',
                mix: { block: 'html-content' },
                content: certification.text
            },
            { elem: 'button' }
        ]);
    });

    bh.match('certification__title', function (ctx) {
        var certification = ctx.tParam('certification');

        ctx.content({
            block: 'link',
            mods: { theme: 'black' },
            url: certification.link,
            content: certification.title
        });
    });
};
