BEM.DOM.decl('contact-form', {
    onSetMod: {
        js: {
            inited: function () {
                this.__base.apply(this, arguments);
                this._findLinkElemes();
                this._bindLinkEvents();
            }
        }
    },
    _findLinkElemes: function () {
        this._modals = this.findBlocksInside(this.findElem('modal-agreement'), 'modal');
        this._links = this.findBlocksInside(this.findElem('modal-agreement'), 'link');
    },
    _bindLinkEvents: function () {
        if (!this._modals || !this._links) {
            return;
        }
        this._links.forEach(this._attachLinkClick.bind(this));
    },
    _attachLinkClick: function (link, index) {
        link.on('click', this._buildLinkClickAction(index));
    },
    _buildLinkClickAction: function (index) {
        var _modal = this._modals[index];

        return function (e) {
            e.preventDefault();
            _modal.setMod('visible', 'yes');
        };
    }
});
