/* eslint-disable max-statements */
module.exports = function (bh) {
    var fullWidthFields = ['textarea', 'checkbox'];

    function input(field, options) {
        options = options || {};
        var userEmail = bh.lib.global.userEmail;

        return [
            {
                block: 'input',
                mods: {
                    size: 'm',
                    type: options.textarea && 'textarea'
                },
                placeholder: options.placeholder && field.label,
                js: {
                    required: field.required,
                    email: options.email,
                    name: field.name
                },
                content: [
                    {
                        elem: 'control'
                    },
                    (options.email && userEmail) && {
                        elem: 'samples',
                        content: {
                            block: 'link',
                            mods: { theme: 'pseudo', pseudo: 'yes' },
                            mix: { block: 'input', elem: 'sample' },
                            content: userEmail
                        }
                    },
                    (options.email || field.required) && {
                        elem: 'message',
                        elemMods: { type: 'error' },
                        content: bh.lib.i18n('forms', options.email ?
                            'form.error.email' : 'form.error.required')
                    }
                ]
            },
            field.tip && {
                elem: 'tip',
                content: field.tip
            }
        ];
    }

    function buildFormField(field, isCompact) {
        var controls = {
            input: function () {
                return input(field, { placeholder: isCompact });
            },
            textarea: function () {
                return input(field, { textarea: true });
            },
            email: function () {
                return input(field, { email: true, placeholder: isCompact });
            },
            select: function () {
                return {
                    elem: 'select',
                    required: field.required,
                    options: field.options,
                    empty: true
                };
            },
            checkbox: function () {
                return { elem: 'checkbox', options: field.options, tip: field.tip };
            }
        };

        var content = controls[field.type] && controls[field.type]();
        var isFullWidth = fullWidthFields.indexOf(field.type) > -1;

        if (!content) {
            return '';
        }

        return {
            elem: 'row',
            mix: {
                block: 'clearfix'
            },
            content: [
                !isCompact && {
                    elem: 'label',
                    content: {
                        elem: 'label-text',
                        mods: {
                            type: isFullWidth && 'full',
                            required: field.required && 'yes'
                        },
                        content: field.label
                    }
                },
                {
                    elem: 'control',
                    mods: { type: isFullWidth && 'full' },
                    content: content
                }
            ]
        };
    }

    bh.match('contact-form', function (ctx, json) {
        var isCompact = json.mods.type === 'compact';
        var fields = json.fields.slice(0);
        var mailListsControl = null;

        if (isCompact) {
            mailListsControl = fields.pop();
        }

        ctx
            .tag('form')
            .content([
                {
                    elem: 'data',
                    content: [
                        json.caption && {
                            elem: 'title',
                            content: json.caption
                        },
                        fields.map(function (item) {
                            return buildFormField(item, isCompact);
                        }),
                        {
                            block: 'secret-key-input'
                        },
                        json.attach && {
                            elem: 'attach'
                        },
                        {
                            elem: 'submit',
                            button: json.button,
                            agreements: json.agreements,
                            mailListsControl: mailListsControl &&
                                buildFormField(mailListsControl, isCompact)
                        }
                    ]
                },
                {
                    elem: 'message',
                    mods: { hidden: 'yes' },
                    content: [
                        {
                            elem: 'message-title',
                            content: json.successTitle || bh.lib.i18n('forms', 'success.def.title')
                        },
                        {
                            tag: 'p',
                            content: json.successText || bh.lib.i18n('forms', 'success.def.text')
                        }
                    ]
                }
            ]);
    });

    bh.match('contact-form__submit', function (ctx, json) {
        if (!json.button) {
            return '';
        }

        return [
            {
                elem: 'agreements',
                agreements: json.agreements
            },
            {
                elem: 'footer',
                elemMods: { align: json.button.align || '' },
                content: [
                    { elem: 'error' },
                    { elem: 'loader' },
                    { elem: 'button', button: json.button }
                ]
            }
        ];
    });

    bh.match('contact-form__error', function (ctx) {
        ctx.content({ elem: 'error-message' });
    });

    bh.match('contact-form__loader', function (ctx) {
        ctx.content({ block: 'spin2', mods: { size: 'm' }});
    });

    bh.match('contact-form__button', function (ctx, json) {
        var mods = bh.lib.util.merge({
            theme: 'action',
            size: 'm'
        }, json.buttonMods);

        return {
            block: 'button',
            mods: mods,
            content: json.button.text
        };
    });

    function buildAgreementFromString(agreement) {
        return {
            elem: 'agreement',
            content: [
                {
                    block: 'checkbox',
                    mods: { theme: 'normal', size: 'm', required: 'yes' },
                    text: {
                        elem: 'label',
                        content: [
                            agreement, {
                                elem: 'message',
                                content: bh.lib.i18n('forms', 'form.error.required')
                            }
                        ]
                    }
                }
            ]
        };
    }

    function buildAgreementFromObject(agreement) {
        var label = agreement.label;
        var description = agreement.description;

        return {
            elem: 'modal-agreement',

            content: [
                {
                    block: 'checkbox',
                    mods: { theme: 'normal', size: 'm', required: 'yes' },
                    text: {
                        elem: 'label',
                        content: [
                            bh.lib.util.template(label),
                            {
                                elem: 'message',
                                content: bh.lib.i18n('forms', 'form.error.required')
                            }
                        ]
                    }
                },
                {
                    block: 'modal',
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes',
                        type: 'basic',
                        size: 's'
                    },
                    content: description
                }
            ]
        };
    }

    function buildAgreement(agreement) {
        return (agreement instanceof Object) ?
            buildAgreementFromObject(agreement) : buildAgreementFromString(agreement);
    }

    bh.match('contact-form__title', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('contact-form__agreements', function (ctx, json) {
        if (!Array.isArray(json.agreements) || !json.agreements.length) {
            return '';
        }

        ctx.content(json.agreements.map(buildAgreement));
    });
};
