BEM.DOM.decl('contact-form', {
    /* eslint-disable max-statements */
    onSetMod: {
        js: function () {
            this.blockName = 'contact-form';
            this._isProcessing = false;
            this._goalId = this.params.metrikaGoalId;
            this._findElems();
            this._bindEvents();
        }
    },

    _findElems: function () {
        this._sk = this.findBlockInside('secret-key-input').domElem.val();
        this._controls = this.findBlocksInside('select').concat(this.findBlocksInside('input'));
        this._agreements = this.findBlocksInside(this.elem('agreements'), 'checkbox');
        this._checkboxes = this.findBlocksInside(this.elem('checkbox'), 'checkbox');
        this._files = this.findBlockInside('file-upload');

        this._fieldsWrapper = this.elem('data');

        this._sendButton = this.findBlockInside({
            block: 'button',
            modName: 'theme',
            modVal: 'action'
        });

        this._spinner = this.findBlockInside('spin2');
        this._responseError = this.findElem('error');
        this._responseErrorMessage = this.findElem('error-message');
    },

    _bindEvents: function () {
        this._sendButton.on('click', this._send.bind(this));

        if (BEM.blocks.select) {
            BEM.blocks.select.on(this._fieldsWrapper, 'change', this._onControlsChange.bind(this));
        }

        if (BEM.blocks.input) {
            BEM.blocks.input.on(this._fieldsWrapper, 'change', this._onControlsChange.bind(this));
        }

        if (BEM.blocks.checkbox) {
            BEM.blocks.checkbox.on(this._fieldsWrapper, 'change', this._onControlsChange.bind(this));
        }
    },

    _onControlsChange: function (event) {
        var block = event.block;

        if (block.domElem.hasClass('select')) {
            var $tip = block.domElem
                .siblings(BEM.blocks['i-bem'].buildSelector(this.blockName, 'tip'));

            $tip.text(block.params.options[block.val()]);
        }

        block.delMod(block.findElem('message'), 'visibility');
    },

    _send: function () {
        var form = {
            form: this._getFormData(),
            formId: this.params.formId,
            agencyId: this.params.agencyId,
            orderId: this.params.orderId,
            subscriptionType: this.params.subscriptionType
        };

        if (!form.form || this._isProcessing || !this.params.url) {
            return;
        }

        this._hideResponseError();
        this._setFormProcessing();

        var data = this._buildFormData(form);
        var requestOptions = {
            type: 'POST',
            url: this.params.url,
            headers: {
                'x-csrf-token': this._sk
            },
            cache: false,
            contentType: false,
            processData: false,
            data: this._buildFormData(form)
        };

        if (data.fake) {
            requestOptions.contentType = 'multipart/form-data; boundary=' + data.boundary;
            requestOptions.data = data.toString();
        }

        $.ajax(requestOptions)
            .done(this._showSuccessMessage.bind(this))
            .fail(this._showResponseError.bind(this))
            .always(this._removeFormProcessing.bind(this));
    },

    _buildFormData: function (form) {
        var data = new FormData();

        for (var field in form) {
            if (typeof form[field] !== 'undefined') {
                data.append(field, JSON.stringify(form[field]));
            }
        }

        if (this._files) {
            var files = this._files.val() || [];

            files.forEach(function (file) {
                data.append('list', file);
            });
        }

        return data;
    },

    _getFormData: function () {
        var result = [];
        var errors = 0;

        this._controls.forEach(function (control) {
            var key = control.domElem
                .closest(BEM.blocks['i-bem'].buildSelector(this.blockName, 'row'))
                .find(BEM.blocks['i-bem'].buildSelector(this.blockName, 'label-text'))
                .text();
            var value = $.trim(control.val());
            var requiredError = control.params.required && !value;
            var isEmail = control.params.email;
            var emailError = isEmail && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value);

            if (requiredError || emailError) {
                this._showErrorOn(control);
                errors += 1;
            }

            result.push({
                label: key,
                value: control.val(),
                name: control.params.name,
                isSelect: control.domElem.hasClass('select'),
                isEmail: isEmail
            });
        }.bind(this));

        this._checkboxes.forEach(function (checkbox) {
            result.push({
                checked: checkbox.isChecked(),
                value: checkbox.val(),
                isCheckbox: true
            });
        });

        this._agreements.forEach(function (agreement) {
            if (!agreement.isChecked()) {
                this._showErrorOn(agreement);
                errors += 1;
            }
        }.bind(this));

        if (errors) {
            return;
        }

        return result;
    },

    _showErrorOn: function (block) {
        block.setMod(block.findElem('message'), 'visibility', 'visible');
    },

    _showSuccessMessage: function () {
        this.trigger('showSuccessMessage');
        this._clearForm();
        this.setMod(this.findElem('data'), 'hidden', 'yes');
        this.delMod(this.findElem('message'), 'hidden');

        if (this._goalId) {
            BEM.blocks.metrika.reachGoal(this._goalId);
        }
    },

    _disableInput: function (item) {
        item.setMod('disabled', 'yes');
    },

    _enableInput: function (item) {
        item.delMod('disabled');
    },

    _setFormProcessing: function () {
        this._spinner.setMod('progress', 'yes');
        this._sendButton.setMod('disabled', 'yes');
        this._isProcessing = true;
        this._checkboxes.forEach(this._disableInput);
        this._controls.forEach(this._disableInput);
        this._agreements.forEach(this._disableInput);
    },

    _removeFormProcessing: function () {
        this._spinner.delMod('progress');
        this._sendButton.delMod('disabled');
        this._isProcessing = false;
        this._controls.forEach(this._enableInput);
        this._checkboxes.forEach(this._enableInput);
        this._agreements.forEach(this._enableInput);
    },

    _showResponseError: function (err) {
        var errorText = this._errorHumanize(err);

        this._responseErrorMessage.html(errorText);
        this.setMod(this._responseErrorMessage, 'visibility', 'visible');
    },

    _hideResponseError: function () {
        this.delMod(this._responseErrorMessage, 'visibility');
        this._responseErrorMessage.text('');
    },

    _errorHumanize: function (err) {
        var responseJSON = err.responseJSON;

        if (responseJSON) {
            var errorMessage = BH.lib.i18n('forms', responseJSON.internalCode, {
                param: responseJSON.message
            });

            return errorMessage || responseJSON.message;
        }

        return err.statusText;
    },

    _clearForm: function () {
        this._controls.forEach(function (input) {
            input.val('');
        });
    }
});
