module.exports = function (bh) {
    'use strict';
    bh.match('content_columns_two', function (ctx) {
        var rows = ctx.param('rows');

        var content = rows.map(function (row) {
            return {
                elem: 'row',
                row: row
            };
        });

        ctx.content(content);
    });

    bh.match('content__row', function (ctx) {
        var row = ctx.param('row');

        ctx.content(row.length > 1 ? [
            {
                elem: 'left-column',
                content: row.shift()
            },
            {
                elem: 'right-column',
                content: row.shift()
            }
        ] : row.shift());
    });
};
